;;; - ------------------------------------------------------------------------------ - ;
;;; -                 T O O L - K_MAKE-TEXT-LT                                       - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung :  Textlinientp erstellen                                         - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Befehle      :  k_make-text-lt                                                 - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 10.04.2024                                                - ;
;;; -              durch : Andreas Kraus                                             - ;
;;; - ------------------------------------------------------------------------------ - ;

(vl-load-com)
(DEFUN :M-ROUND	(#REAL)
  (COND	((= (QUOTE REAL) (TYPE #REAL))
	 (IF (<= 0.5 (ABS (REM #REAL 1)))
	   (IF (> #REAL 0)
	     (1+ (FIX #REAL))
	     (1- (FIX #REAL))
	   )
	   (FIX #REAL)
	 )
	)
	(#REAL)
  )
)
(DEFUN :M-ROUNDTOEVEN (#NUMLST)
  (MAPCAR (QUOTE (LAMBDA (N)
		   (IF (/= (REM N 1) 0.5)
		     (:M-ROUND N)
		     (PROGN (IF	(> N 0)
			      (* 2 (:M-ROUND (/ N 2)))
			      (* 2 (:M-ROUND (/ N 2)) -1)
			    )
		     )
		   )
		 )
	  )
	  #NUMLST
  )
)
(DEFUN I-CDR (LST) (REVERSE (CDR (REVERSE LST))))
(DEFUN K_->ENT_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME)) NAME)
	((= (TYPE NAME) (QUOTE VLA-OBJECT))
	 (vlax-vla-object->ename NAME)
	)
	((= (TYPE NAME) (QUOTE STR)) (HANDENT NAME))
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC -1 NAME))
	 (CDR (ASSOC -1 NAME))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC 5 NAME))
	 (HANDENT (CDR (ASSOC 5 NAME)))
	)
  )
)
(DEFUN K_->OBJ_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME))
	 (vlax-ename->vla-object NAME)
	)
	((= (TYPE NAME) (QUOTE VLA-OBJECT)) NAME)
	((= (TYPE NAME) (QUOTE STR))
	 (vlax-ename->vla-object (HANDENT NAME))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC -1 NAME))
	 (vlax-ename->vla-object (CDR (ASSOC -1 NAME)))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC 5 NAME))
	 (vlax-ename->vla-object (HANDENT (CDR (ASSOC 5 NAME))))
	)
  )
)
(DEFUN K_3D->2D	(WERT / DUMMY)
  (IF (VL-EVERY	(QUOTE (LAMBDA (DUMMY) (= (TYPE DUMMY) (QUOTE LIST))))
		WERT
      )
    (MAPCAR (QUOTE (LAMBDA (DUMMY) (LIST (CAR DUMMY) (CADR DUMMY))))
	    WERT
    )
    (LIST (CAR WERT) (CADR WERT))
  )
)
(DEFUN K_AC-DOC	nil
  (vla-get-ActiveDocument (vlax-get-acad-object))
)
(DEFUN K_COLLECTION->LIST (COLLECTION / LISTE)
  (COND	((MEMBER "VLA-COLLECTION->LIST" (ATOMS-FAMILY 1))
	 (SETQ LISTE (VLA-COLLECTION->LIST COLLECTION))
	)
	((MEMBER "VLAX-FOR" (ATOMS-FAMILY 1))
	 (SETQ LISTE (LIST))
	 (VLAX-FOR DUMMY COLLECTION (SETQ LISTE (CONS DUMMY LISTE)))
	 (REVERSE LISTE)
	)
  )
  LISTE
)
(DEFUN K_COPYOBJECTS (OBJ_LIST QUELLE ZIEL RET / NEW_LIST)
  (IF (NULL QUELLE)
    (SETQ QUELLE (K_AC-DOC))
  )
  (COND	((= (TYPE OBJ_LIST) (QUOTE ENAME))
	 (SETQ OBJ_LIST (LIST (vlax-ename->vla-object OBJ_LIST)))
	)
	((= (TYPE OBJ_LIST) (QUOTE VLA-OBJECT))
	 (SETQ OBJ_LIST (LIST OBJ_LIST))
	)
	((= (TYPE OBJ_LIST) (QUOTE LIST))
	 (SETQ OBJ_LIST (MAPCAR (QUOTE K_->OBJ_NAME) OBJ_LIST))
	)
	(T nil)
  )
  (SETQ	OBJ_LIST (VL-REMOVE (QUOTE nil)
			    (MAPCAR (QUOTE
				      (LAMBDA (OBJ)
					(COND ((= (TYPE OBJ) (QUOTE ENAME)) (vlax-ename->vla-object OBJ))
					      ((= (TYPE OBJ) (QUOTE VLA-OBJECT)) OBJ)
					      (T nil)
					)
				      )
				    )
				    OBJ_LIST
			    )
		 )
  )
  (SETQ	NEW_LIST (VL-CATCH-ALL-APPLY
		   (QUOTE vlax-invoke)
		   (LIST QUELLE (QUOTE COPYOBJECTS) OBJ_LIST ZIEL)
		 )
  )
  (IF RET
    NEW_LIST
    nil
  )
)
(DEFUN K_DIALOGSPEICHER	(TODO / DATA_LIST)
  (IF TODO
    (IF	(LISTP TODO)
      (K_PUT_MERKLISTE
	"dialogspeicher"
	(SETQ DATA_LIST	(VL-REMOVE-IF
			  (QUOTE (LAMBDA (EINTRAG) (NULL (CADR EINTRAG))))
			  (MAPCAR (QUOTE (LAMBDA (Q) (ASSOC Q DATA_LIST)))
				  (K_PURGE_LIST
				    (MAPCAR (QUOTE CAR)
					    (SETQ DATA_LIST (APPEND (MAPCAR (QUOTE (LAMBDA (DUMMY)
										     (IF (LISTP DUMMY)
										       DUMMY
										       (LIST DUMMY (GET_TILE DUMMY))
										     )
										   )
									    )
									    TODO
								    )
								    (K_GET_MERKLISTE "dialogspeicher")
							    )
					    )
				    )
				  )
			  )
			)
	)
      )
      (MAPCAR (QUOTE
		(LAMBDA	(DUMMY)
		  (COND	((= (TYPE (GET_TILE (CAR DUMMY))) (QUOTE STR))
			 (SET_TILE (CAR DUMMY) (VL-PRINC-TO-STRING (CADR DUMMY)))
			)
		  )
		)
	      )
	      (K_GET_MERKLISTE "dialogspeicher")
      )
    )
    (K_PUT_MERKLISTE "dialogspeicher" nil)
  )
  DATA_LIST
)
(DEFUN K_DRAW_IMAGE (IMAGE_NAME	       DATA_LIST	 /	  ART	   B	    BREITE   C	      CENTER   CHR_LIST	COLOR	 C_LIST	  DATA	   DUMMY    DUMMY_LIST	      DX       DY
		     END      FONT_LIST		H	 HEIGHT	  HOEHE	   MAX-X    MAX-Y    MIN-X    MIN-Y    P	P1	 P2	  P3	   P4	    PL	     PLIST    POS      POSITION
		     P_LIST   RADIUS   RATIO	RICHTUNG SIZE	  START	   TEMP_LIST	     TEXT     W	       WIDTH	WINKEL	 W_LIST	  X-LIST   Y-LIST   Z
		    )
  (SETQ	FONT_LIST (QUOTE
		    ((" " ((1 0.0 0.0) (2 0.5 0.0)))
		      ("" ((1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.33 0.0)
			     (1 0.5 0.17)
			     (1 0.5 0.33)
			     (1 0.33 0.5)
			     (1 0.33 0.67)
			     (0 0 0)
			     (1 0.33 0.83)
			     (1 0.33 1.0)
			     (2 0.6 0.0)
			   )
		      )
		      ("" ((1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.33 0.0)
			     (1 0.5 0.17)
			     (1 0.5 0.33)
			     (1 0.33 0.5)
			     (1 0.33 0.67)
			     (0 0 0)
			     (1 0.33 0.83)
			     (1 0.33 1.0)
			     (2 0.6 0.0)
			   )
		      )
		      ("]" ((1 0.0 0.0)
			     (1 0.33 0.0)
			     (1 0.33 1.0)
			     (1 0.0 1.0)
			     (2 0.43 0.0)
			   )
		      )
		      ("[" ((1 0.33 1.0)
			     (1 0.0 1.0)
			     (1 0.0 0.0)
			     (1 0.33 0.0)
			     (2 0.43 0.0)
			   )
		      )
		      ("}" ((1 0.0 1.0)
			     (1 0.17 0.83)
			     (1 0.17 0.67)
			     (1 0.33 0.5)
			     (1 0.17 0.33)
			     (1 0.17 0.17)
			     (1 0.0 0.0)
			     (2 0.43 0.0)
			   )
		      )
		      ("{" ((1 0.33 0.0)
			     (1 0.17 0.17)
			     (1 0.17 0.33)
			     (1 0.0 0.5)
			     (1 0.17 0.67)
			     (1 0.17 0.83)
			     (1 0.33 1.0)
			     (2 0.43 0.0)
			   )
		      )
		      ("" ((1 0.17 0.0)
			     (1 0.33 0.17)
			     (1 0.17 0.33)
			     (1 0.0 0.17)
			     (2 0.43 0.0)
			   )
		      )
		      ("^" ((1 0.0 0.33) (1 0.33 0.0) (1 0.67 0.33) (2 0.77 0.0)))
		      ("+" ((1 0.33 0.83)
			     (1 0.33 0.17)
			     (0 0 0)
			     (1 0.67 0.5)
			     (1 0.0 0.5)
			     (2 0.77 0.0)
			   )
		      )
		      ("*" ((1 0.33 0.83)
			     (1 0.33 0.17)
			     (0 0 0)
			     (1 0.67 0.5)
			     (1 0.0 0.5)
			     (0 0 0)
			     (1 0.67 0.17)
			     (1 0.0 0.83)
			     (0 0 0)
			     (1 0.0 0.17)
			     (1 0.67 0.83)
			     (2 0.77 0.0)
			   )
		      )
		      ("#" ((1 0.0 0.67)
			     (1 0.67 0.67)
			     (0 0 0)
			     (1 0.67 0.33)
			     (1 0.0 0.33)
			     (0 0 0)
			     (1 0.17 0.0)
			     (1 0.17 1.0)
			     (0 0 0)
			     (1 0.5 1.0)
			     (1 0.5 0.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("'" ((1 0.0 0.33) (1 0.17 0.0) (2 0.27 0.0)))
		      (">" ((1 0.0 0.0) (1 0.5 0.5) (1 0.0 1.0) (2 0.6 0.0)))
		      ("<" ((1 0.5 0.0) (1 0.0 0.5) (1 0.5 1.0) (2 0.6 0.0)))
		      ("_" ((1 0.0 1.17) (1 0.67 1.17) (2 0.77 0.0)))
		      (":" ((1 0.0 0.33)
			     (1 0.0 0.5)
			     (0 0 0)
			     (1 0.0 0.67)
			     (1 0.0 0.83)
			     (2 0.1 0.0)
			   )
		      )
		      (";" ((1 0.17 0.33)
			     (1 0.17 0.5)
			     (0 0 0)
			     (1 0.17 0.67)
			     (1 0.17 1.0)
			     (1 0.0 1.17)
			     (2 0.27 0.0)
			   )
		      )
		      ("-" ((1 0.0 0.5) (1 0.67 0.5) (2 0.77 0.0)))
		      ("." ((1 0.0 1.0) (1 0.0 0.83) (2 0.1 0.0)))
		      ("," ((1 0.17 0.83) (1 0.17 1.0) (1 0.0 1.17) (2 0.27 0.0)))
		      ("?" ((1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.33 0.0)
			     (1 0.5 0.17)
			     (1 0.5 0.33)
			     (1 0.33 0.5)
			     (1 0.33 0.67)
			     (0 0 0)
			     (1 0.33 0.83)
			     (1 0.33 1.0)
			     (2 0.6 0.0)
			   )
		      )
		      ("=" ((1 0.0 0.33)
			     (1 0.67 0.33)
			     (0 0 0)
			     (1 0.67 0.67)
			     (1 0.0 0.67)
			     (2 0.77 0.0)
			   )
		      )
		      (")" ((1 0.0 0.0)
			     (1 0.33 0.33)
			     (1 0.33 0.67)
			     (1 0.0 1.0)
			     (2 0.43 0.0)
			   )
		      )
		      ("(" ((1 0.33 0.0)
			     (1 0.0 0.33)
			     (1 0.0 0.67)
			     (1 0.33 1.0)
			     (2 0.43 0.0)
			   )
		      )
		      ("/" ((1 0.0 1.0) (1 0.67 0.0) (2 0.77 0.0)))
		      ("&" ((1 0.67 0.67)
			     (1 0.33 1.0)
			     (1 0.17 1.0)
			     (1 0.0 0.83)
			     (1 0.0 0.67)
			     (1 0.33 0.33)
			     (1 0.33 0.17)
			     (1 0.17 0.0)
			     (1 0.0 0.17)
			     (1 0.0 0.33)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("%" ((1 0.0 0.17)
			     (1 0.17 0.17)
			     (1 0.17 0.0)
			     (1 0.0 0.0)
			     (0 0 0)
			     (1 0.67 0.0)
			     (1 0.0 1.0)
			     (0 0 0)
			     (1 0.5 1.0)
			     (1 0.5 0.83)
			     (1 0.67 0.83)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("$" ((1 0.0 0.83)
			     (1 0.5 0.83)
			     (1 0.67 0.67)
			     (1 0.5 0.5)
			     (1 0.17 0.5)
			     (1 0.0 0.33)
			     (1 0.17 0.17)
			     (1 0.67 0.17)
			     (0 0 0)
			     (1 0.33 0.0)
			     (1 0.33 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("" ((1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.33 1.0)
			     (1 0.5 0.83)
			     (1 0.33 0.67)
			     (0 0 0)
			     (1 0.5 0.17)
			     (1 0.33 0.0)
			     (1 0.17 0.0)
			     (1 0.0 0.17)
			     (1 0.17 0.33)
			     (1 0.33 0.33)
			     (1 0.5 0.5)
			     (1 0.33 0.67)
			     (1 0.17 0.67)
			     (1 0.0 0.5)
			     (1 0.17 0.33)
			     (2 0.6 0.0)
			   )
		      )
		      ("\"" ((1 0.0 0.33)
			      (1 0.17 0.0)
			      (0 0 0)
			      (1 0.33 0.0)
			      (1 0.17 0.33)
			      (2 0.43 0.0)
			    )
		      )
		      ("!" ((1 0.0 1.0)
			     (1 0.0 0.83)
			     (0 0 0)
			     (1 0.0 0.67)
			     (1 0.0 0.0)
			     (2 0.1 0.0)
			   )
		      )
		      ("" ((1 0.0 1.0)
			     (1 0.17 0.83)
			     (1 0.17 0.17)
			     (1 0.33 0.0)
			     (1 0.5 0.0)
			     (1 0.67 0.17)
			     (1 0.67 0.33)
			     (1 0.5 0.5)
			     (1 0.67 0.67)
			     (1 0.67 0.83)
			     (1 0.5 1.0)
			     (1 0.33 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("" ((1 0.0 0.0)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.5 1.0)
			     (1 0.67 0.83)
			     (1 0.67 0.0)
			     (0 0 0)
			     (1 0.5 0.17)
			     (1 0.5 0.0)
			     (0 0 0)
			     (1 0.17 0.0)
			     (1 0.17 0.17)
			     (2 0.77 0.0)
			   )
		      )
		      ("" ((1 0.17 0.17)
			     (1 0.17 0.0)
			     (0 0 0)
			     (1 0.5 0.17)
			     (1 0.5 0.0)
			     (0 0 0)
			     (1 0.0 0.33)
			     (1 0.67 0.33)
			     (1 0.67 1.0)
			     (1 0.0 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("" ((1 0.0 1.0)
			     (1 0.0 0.67)
			     (0 0 0)
			     (1 0.0 0.17)
			     (1 0.0 0.0)
			     (0 0 0)
			     (1 0.67 0.0)
			     (1 0.67 0.17)
			     (0 0 0)
			     (1 0.67 0.67)
			     (1 0.33 0.0)
			     (1 0.0 0.67)
			     (1 0.67 0.67)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("" ((1 0.17 0.0)
			     (1 0.17 0.17)
			     (0 0 0)
			     (1 0.0 0.33)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.33 1.0)
			     (1 0.67 0.67)
			     (0 0 0)
			     (1 0.5 0.0)
			     (1 0.5 0.17)
			     (0 0 0)
			     (1 0.67 0.33)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("" ((1 0.0 0.0)
			     (1 0.0 0.17)
			     (0 0 0)
			     (1 0.67 0.17)
			     (1 0.67 0.0)
			     (0 0 0)
			     (1 0.17 1.0)
			     (1 0.0 0.83)
			     (1 0.0 0.5)
			     (1 0.17 0.33)
			     (1 0.5 0.33)
			     (1 0.67 0.5)
			     (1 0.67 0.83)
			     (1 0.5 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("" ((1 0.0 0.0)
			     (1 0.0 0.17)
			     (0 0 0)
			     (1 0.5 0.17)
			     (1 0.5 0.0)
			     (0 0 0)
			     (1 0.5 0.83)
			     (1 0.5 0.5)
			     (1 0.33 0.33)
			     (1 0.17 0.33)
			     (1 0.0 0.5)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.33 1.0)
			     (1 0.5 0.83)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("Z" ((1 0.0 0.0)
			     (1 0.67 0.0)
			     (1 0.0 1.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("Y" ((1 0.0 0.0)
			     (1 0.33 0.5)
			     (0 0 0)
			     (1 0.33 1.0)
			     (1 0.33 0.5)
			     (1 0.67 0.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("X" ((1 0.0 1.0)
			     (1 0.67 0.0)
			     (0 0 0)
			     (1 0.0 0.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("W" ((1 0.0 0.0)
			     (1 0.33 1.0)
			     (1 0.5 0.5)
			     (1 0.67 1.0)
			     (1 1.0 0.0)
			     (2 1.1 0.0)
			   )
		      )
		      ("V" ((1 0.0 0.0) (1 0.5 1.0) (1 1.0 0.0) (2 1.1 0.0)))
		      ("U" ((1 0.0 0.0)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.5 1.0)
			     (1 0.67 0.83)
			     (1 0.67 0.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("T" ((1 0.0 0.0)
			     (1 0.67 0.0)
			     (0 0 0)
			     (1 0.33 0.0)
			     (1 0.33 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("S" ((1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.5 1.0)
			     (1 0.67 0.83)
			     (1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.5 0.0)
			     (1 0.67 0.17)
			     (2 0.77 0.0)
			   )
		      )
		      ("R" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (1 0.5 0.0)
			     (1 0.67 0.17)
			     (1 0.67 0.33)
			     (1 0.5 0.5)
			     (1 0.0 0.5)
			     (0 0 0)
			     (1 0.17 0.5)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("Q" ((1 0.33 0.67)
			     (1 0.5 0.83)
			     (1 0.33 1.0)
			     (1 0.17 1.0)
			     (1 0.0 0.83)
			     (1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.5 0.0)
			     (1 0.67 0.17)
			     (1 0.67 0.67)
			     (1 0.5 0.83)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("P" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (1 0.5 0.0)
			     (1 0.67 0.17)
			     (1 0.67 0.33)
			     (1 0.5 0.5)
			     (1 0.0 0.5)
			     (2 0.77 0.0)
			   )
		      )
		      ("O" ((1 0.0 0.0)
			     (1 0.67 0.0)
			     (1 0.67 1.0)
			     (1 0.0 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("N" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (1 0.67 1.0)
			     (1 0.67 0.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("M" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (1 0.33 0.67)
			     (1 0.67 0.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("L" ((1 0.0 0.0) (1 0.0 1.0) (1 0.67 1.0) (2 0.77 0.0)))
		      ("K" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (0 0 0)
			     (1 0.67 0.0)
			     (1 0.17 0.5)
			     (0 0 0)
			     (1 0.0 0.5)
			     (1 0.17 0.5)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("J" ((1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.5 1.0)
			     (1 0.67 0.83)
			     (1 0.67 0.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("I" ((1 0.0 0.0)
			     (1 0.33 0.0)
			     (0 0 0)
			     (1 0.17 0.0)
			     (1 0.17 1.0)
			     (0 0 0)
			     (1 0.0 1.0)
			     (1 0.33 1.0)
			     (2 0.43 0.0)
			   )
		      )
		      ("H" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (0 0 0)
			     (1 0.0 0.5)
			     (1 0.67 0.5)
			     (0 0 0)
			     (1 0.67 0.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("G" ((1 0.5 0.5)
			     (1 0.67 0.5)
			     (1 0.67 1.0)
			     (1 0.17 1.0)
			     (1 0.0 0.83)
			     (1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.67 0.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("F" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (1 0.67 0.0)
			     (0 0 0)
			     (1 0.0 0.5)
			     (1 0.33 0.5)
			     (2 0.77 0.0)
			   )
		      )
		      ("E" ((1 0.0 0.5)
			     (1 0.33 0.5)
			     (0 0 0)
			     (1 0.67 0.0)
			     (1 0.0 0.0)
			     (1 0.0 1.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("D" ((1 0.0 1.0)
			     (1 0.5 1.0)
			     (1 0.67 0.83)
			     (1 0.67 0.17)
			     (1 0.5 0.0)
			     (1 0.0 0.0)
			     (0 0 0)
			     (1 0.17 0.0)
			     (1 0.17 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("C" ((1 0.67 0.83)
			     (1 0.5 1.0)
			     (1 0.17 1.0)
			     (1 0.0 0.83)
			     (1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.5 0.0)
			     (1 0.67 0.17)
			     (2 0.77 0.0)
			   )
		      )
		      ("B" ((1 0.0 1.0)
			     (1 0.5 1.0)
			     (1 0.67 0.83)
			     (1 0.67 0.67)
			     (1 0.5 0.5)
			     (0 0 0)
			     (1 0.17 0.5)
			     (1 0.5 0.5)
			     (1 0.67 0.33)
			     (1 0.67 0.17)
			     (1 0.5 0.0)
			     (1 0.0 0.0)
			     (0 0 0)
			     (1 0.17 0.0)
			     (1 0.17 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("A" ((1 0.0 1.0)
			     (1 0.0 0.67)
			     (0 0 0)
			     (1 0.67 0.67)
			     (1 0.33 0.0)
			     (1 0.0 0.67)
			     (1 0.67 0.67)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("z" ((1 0.0 0.33)
			     (1 0.67 0.33)
			     (1 0.0 1.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("y" ((1 0.0 0.33)
			     (1 0.33 1.0)
			     (0 0 0)
			     (1 0.67 0.33)
			     (1 0.17 1.33)
			     (1 0.0 1.33)
			     (2 0.77 0.0)
			   )
		      )
		      ("x" ((1 0.0 1.0)
			     (1 0.67 0.33)
			     (0 0 0)
			     (1 0.0 0.33)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("w" ((1 0.0 0.33)
			     (1 0.17 1.0)
			     (1 0.33 0.33)
			     (1 0.5 1.0)
			     (1 0.67 0.33)
			     (2 0.77 0.0)
			   )
		      )
		      ("v" ((1 0.0 0.33) (1 0.33 1.0) (1 0.67 0.33) (2 0.77 0.0)))
		      ("u" ((1 0.0 0.33)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.33 1.0)
			     (1 0.67 0.67)
			     (0 0 0)
			     (1 0.67 0.33)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("t" ((1 0.0 0.33)
			     (1 0.67 0.33)
			     (0 0 0)
			     (1 0.33 0.0)
			     (1 0.33 0.83)
			     (1 0.5 1.0)
			     (1 0.67 0.83)
			     (2 0.77 0.0)
			   )
		      )
		      ("s" ((1 0.0 1.0)
			     (1 0.5 1.0)
			     (1 0.67 0.83)
			     (1 0.5 0.67)
			     (1 0.17 0.67)
			     (1 0.0 0.5)
			     (1 0.17 0.33)
			     (1 0.67 0.33)
			     (2 0.77 0.0)
			   )
		      )
		      ("r" ((1 0.0 1.0)
			     (1 0.0 0.33)
			     (0 0 0)
			     (1 0.0 0.67)
			     (1 0.33 0.33)
			     (1 0.5 0.33)
			     (1 0.67 0.5)
			     (2 0.77 0.0)
			   )
		      )
		      ("q" ((1 0.67 1.33)
			     (1 0.67 0.33)
			     (0 0 0)
			     (1 0.67 0.5)
			     (1 0.5 0.33)
			     (1 0.17 0.33)
			     (1 0.0 0.5)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("p" ((1 0.0 1.33)
			     (1 0.0 0.33)
			     (0 0 0)
			     (1 0.0 0.5)
			     (1 0.17 0.33)
			     (1 0.5 0.33)
			     (1 0.67 0.5)
			     (1 0.67 0.83)
			     (1 0.5 1.0)
			     (1 0.0 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("o" ((1 0.17 1.0)
			     (1 0.0 0.83)
			     (1 0.0 0.5)
			     (1 0.17 0.33)
			     (1 0.5 0.33)
			     (1 0.67 0.5)
			     (1 0.67 0.83)
			     (1 0.5 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("n" ((1 0.0 1.0)
			     (1 0.0 0.33)
			     (0 0 0)
			     (1 0.0 0.67)
			     (1 0.33 0.33)
			     (1 0.5 0.33)
			     (1 0.67 0.5)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("m" ((1 0.0 1.0)
			     (1 0.0 0.33)
			     (0 0 0)
			     (1 0.0 0.5)
			     (1 0.17 0.33)
			     (1 0.33 0.5)
			     (0 0 0)
			     (1 0.33 0.67)
			     (1 0.33 0.5)
			     (1 0.5 0.33)
			     (1 0.67 0.5)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("l" ((1 0.0 0.0) (1 0.0 0.83) (1 0.17 1.0) (2 0.27 0.0)))
		      ("k" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (0 0 0)
			     (1 0.0 0.67)
			     (1 0.33 0.67)
			     (0 0 0)
			     (1 0.67 0.33)
			     (1 0.33 0.67)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("j" ((1 0.0 1.17)
			     (1 0.17 1.33)
			     (1 0.33 1.33)
			     (1 0.5 1.17)
			     (1 0.5 0.33)
			     (0 0 0)
			     (1 0.5 0.17)
			     (1 0.5 0.0)
			     (2 0.6 0.0)
			   )
		      )
		      ("i" ((1 0.0 1.0)
			     (1 0.0 0.33)
			     (0 0 0)
			     (1 0.0 0.17)
			     (1 0.0 0.0)
			     (2 0.1 0.0)
			   )
		      )
		      ("h" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (0 0 0)
			     (1 0.0 0.67)
			     (1 0.33 0.33)
			     (1 0.5 0.33)
			     (1 0.67 0.5)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("g" ((1 0.0 1.17)
			     (1 0.17 1.33)
			     (1 0.5 1.33)
			     (1 0.67 1.17)
			     (1 0.67 0.5)
			     (1 0.5 0.33)
			     (1 0.17 0.33)
			     (1 0.0 0.5)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("f" ((1 0.0 0.5)
			     (1 0.5 0.5)
			     (0 0 0)
			     (1 0.67 0.17)
			     (1 0.5 0.0)
			     (1 0.33 0.0)
			     (1 0.17 0.17)
			     (1 0.17 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("e" ((1 0.0 0.67)
			     (1 0.5 0.67)
			     (1 0.67 0.5)
			     (1 0.5 0.33)
			     (1 0.17 0.33)
			     (1 0.0 0.5)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.5 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("d" ((1 0.33 1.0)
			     (1 0.17 1.0)
			     (1 0.0 0.83)
			     (1 0.0 0.5)
			     (1 0.17 0.33)
			     (1 0.33 0.33)
			     (1 0.67 0.67)
			     (0 0 0)
			     (1 0.67 0.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("c" ((1 0.67 0.33)
			     (1 0.17 0.33)
			     (1 0.0 0.5)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("b" ((1 0.0 1.0)
			     (1 0.0 0.0)
			     (0 0 0)
			     (1 0.33 0.33)
			     (1 0.5 0.33)
			     (1 0.67 0.5)
			     (1 0.67 0.83)
			     (1 0.5 1.0)
			     (1 0.33 1.0)
			     (1 0.0 0.67)
			     (2 0.77 0.0)
			   )
		      )
		      ("a" ((1 0.5 0.83)
			     (1 0.5 0.5)
			     (1 0.33 0.33)
			     (1 0.17 0.33)
			     (1 0.0 0.5)
			     (1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.33 1.0)
			     (1 0.5 0.83)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("9" ((1 0.17 1.0)
			     (1 0.33 1.0)
			     (1 0.67 0.67)
			     (1 0.67 0.17)
			     (1 0.5 0.0)
			     (1 0.17 0.0)
			     (1 0.0 0.17)
			     (1 0.0 0.33)
			     (1 0.17 0.5)
			     (1 0.67 0.5)
			     (2 0.77 0.0)
			   )
		      )
		      ("8" ((1 0.17 0.5)
			     (1 0.5 0.5)
			     (0 0 0)
			     (1 0.17 0.0)
			     (1 0.5 0.0)
			     (1 0.67 0.17)
			     (1 0.67 0.33)
			     (1 0.5 0.5)
			     (1 0.67 0.67)
			     (1 0.67 0.83)
			     (1 0.5 1.0)
			     (1 0.17 1.0)
			     (1 0.0 0.83)
			     (1 0.0 0.67)
			     (1 0.17 0.5)
			     (1 0.0 0.33)
			     (1 0.0 0.17)
			     (2 0.77 0.0)
			   )
		      )
		      ("7" ((1 0.0 0.0) (1 0.67 0.0) (1 0.17 1.0) (2 0.77 0.0)))
		      ("6" ((1 0.0 0.5)
			     (1 0.5 0.5)
			     (1 0.67 0.67)
			     (1 0.67 0.83)
			     (1 0.5 1.0)
			     (1 0.17 1.0)
			     (1 0.0 0.83)
			     (1 0.0 0.33)
			     (1 0.33 0.0)
			     (1 0.5 0.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("5" ((1 0.0 0.83)
			     (1 0.17 1.0)
			     (1 0.5 1.0)
			     (1 0.67 0.83)
			     (1 0.67 0.5)
			     (1 0.5 0.33)
			     (1 0.0 0.33)
			     (1 0.0 0.0)
			     (1 0.67 0.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("4" ((1 0.67 0.67)
			     (1 0.0 0.67)
			     (1 0.5 0.0)
			     (1 0.5 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("3" ((1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.5 0.0)
			     (1 0.67 0.17)
			     (1 0.67 0.33)
			     (1 0.5 0.5)
			     (0 0 0)
			     (1 0.33 0.5)
			     (1 0.5 0.5)
			     (1 0.67 0.67)
			     (1 0.67 0.83)
			     (1 0.5 1.0)
			     (1 0.17 1.0)
			     (1 0.0 0.83)
			     (2 0.77 0.0)
			   )
		      )
		      ("2" ((1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.5 0.0)
			     (1 0.67 0.17)
			     (1 0.67 0.33)
			     (1 0.5 0.5)
			     (1 0.17 0.5)
			     (1 0.0 0.67)
			     (1 0.0 1.0)
			     (1 0.67 1.0)
			     (2 0.77 0.0)
			   )
		      )
		      ("1" ((1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.17 1.0)
			     (0 0 0)
			     (1 0.0 1.0)
			     (1 0.33 1.0)
			     (2 0.43 0.0)
			   )
		      )
		      ("0" ((1 0.0 0.83)
			     (1 0.0 0.17)
			     (1 0.17 0.0)
			     (1 0.33 0.0)
			     (1 0.5 0.17)
			     (1 0.5 0.83)
			     (1 0.33 1.0)
			     (1 0.17 1.0)
			     (2 0.6 0.0)
			   )
		      )
		    )
		  )
  )
  (SETQ B (DIMX_TILE IMAGE_NAME))
  (SETQ H (DIMY_TILE IMAGE_NAME))
  (SETQ W 15)
  (SETQ W_LIST nil)
  (REPEAT 16
    (SETQ W_LIST (CONS (* (/ (* 2.0 PI) 16.0) W) W_LIST))
    (SETQ W (1- W))
  )
  (SETQ	DATA_LIST (MAPCAR (QUOTE
			    (LAMBDA (DATA)
			      (CONS (STRCASE (CAR DATA))
				    (MAPCAR (QUOTE (LAMBDA (DAT) (CONS (STRCASE (CAR DAT)) (CDR DAT))))
					    (CDR DATA)
				    )
			      )
			    )
			  )
			  DATA_LIST
		  )
  )
  (FOREACH DATA	DATA_LIST
    (SETQ ART (CAR DATA))
    (SETQ DATA (CDR DATA))
    (COND ((= ART "FILL")
	   (SETQ COLOR (CADR (ASSOC "COLOR" DATA)))
	   (IF (SETQ P1 (CADR (ASSOC "P1" DATA)))
	     (SETQ P1X (:M-ROUND (* (/ B 100.0) (CAR P1)))
		   P1Y (:M-ROUND (* (/ H 100.0) (CADR P1)))
	     )
	     (SETQ P1X 0
		   P1Y 0
	     )
	   )
	   (IF (SETQ P2 (CADR (ASSOC "P2" DATA)))
	     (SETQ P2X (:M-ROUND
			 (- (* (/ B 100.0) (CAR P2)) (* (/ B 100.0) (CAR P1)))
		       )
		   P2Y (:M-ROUND
			 (- (* (/ H 100.0) (CADR P2)) (* (/ H 100.0) (CADR P1)))
		       )
	     )
	     (SETQ P2X B
		   P2Y H
	     )
	   )
	   (START_IMAGE IMAGE_NAME)
	   (FILL_IMAGE P1X P1Y P2X P2Y COLOR)
	   (END_IMAGE)
	  )
	  ((= ART "CIRCLE")
	   (SETQ CENTER (CADR (ASSOC "CENTER" DATA)))
	   (SETQ COLOR (CADR (ASSOC "COLOR" DATA)))
	   (SETQ RADIUS (CADR (ASSOC "RADIUS" DATA)))
	   (SETQ CENTER	(MAPCAR	(QUOTE *)
				(MAPCAR (QUOTE /) (LIST B H) (LIST 100.0 100.0))
				CENTER
			)
	   )
	   (SETQ RADIUS (* (/ 100.0 (APPLY (QUOTE MIN) (LIST B H))) RADIUS))
	   (IF (NULL (SETQ RATIO (CADR (ASSOC "RATIO" DATA))))
	     (SETQ RATIO 1.0)
	   )
	   (IF (NULL (SETQ WINKEL (CADR (ASSOC "ANGLE" DATA))))
	     (SETQ WINKEL 0)
	   )
	   (SETQ DUMMY_LIST
		  (MAPCAR (QUOTE
			    (LAMBDA (W)
			      (MAPCAR (QUOTE FIX)
				      (MAPCAR (QUOTE +)
					      (K_P_TWIST (MAPCAR (QUOTE *)
								 (POLAR (QUOTE (0 0)) W RADIUS)
								 (LIST 1.0 RATIO)
							 )
							 (QUOTE (0 0))
							 (- 0 WINKEL)
					      )
					      CENTER
				      )
			      )
			    )
			  )
			  W_LIST
		  )
	   )
	   (SETQ P_LIST	(APPEND	P_LIST
				(MAPCAR	(QUOTE (LAMBDA (P1 P2) (LIST P1 P2 COLOR)))
					DUMMY_LIST
					(APPEND (CDR DUMMY_LIST) (LIST (CAR DUMMY_LIST)))
				)
			)
	   )
	  )
	  ((= ART "RECTANG")
	   (SETQ POSITION (CADR (ASSOC "POSITION" DATA)))
	   (SETQ COLOR (CADR (ASSOC "COLOR" DATA)))
	   (SETQ WIDTH (CADR (ASSOC "WIDTH" DATA)))
	   (SETQ HEIGHT (CADR (ASSOC "HEIGHT" DATA)))
	   (SETQ POSITION (MAPCAR (QUOTE *)
				  (MAPCAR (QUOTE /) (LIST B H) (LIST 100.0 100.0))
				  POSITION
			  )
	   )
	   (SETQ HEIGHT (* (/ H 100.0) HEIGHT))
	   (SETQ WIDTH (* (/ B 100.0) WIDTH))
	   (IF (NULL (SETQ WINKEL (CADR (ASSOC "ANGLE" DATA))))
	     (SETQ WINKEL 0)
	   )
	   (SETQ P1 (POLAR (POLAR (QUOTE (0 0)) 0 (/ WIDTH 2.0))
			   (* PI 1.5)
			   (/ HEIGHT 2.0)
		    )
	   )
	   (SETQ P2 (POLAR P1 (* PI 0.5) HEIGHT))
	   (SETQ P3 (POLAR P2 PI WIDTH))
	   (SETQ P4 (POLAR P3 (* PI 1.5) HEIGHT))
	   (SETQ DUMMY_LIST
		  (MAPCAR (QUOTE
			    (LAMBDA (P)
			      (MAPCAR (QUOTE :M-ROUND)
				      (MAPCAR (QUOTE +)
					      (K_P_TWIST P (QUOTE (0 0)) (- 0 WINKEL))
					      POSITION
				      )
			      )
			    )
			  )
			  (LIST P1 P2 P3 P4)
		  )
	   )
	   (SETQ P_LIST	(APPEND	P_LIST
				(MAPCAR	(QUOTE (LAMBDA (P1 P2) (LIST P1 P2 COLOR)))
					DUMMY_LIST
					(APPEND (CDR DUMMY_LIST) (LIST (CAR DUMMY_LIST)))
				)
			)
	   )
	  )
	  ((= ART "ARROW")
	   (SETQ START (CADR (ASSOC "START" DATA)))
	   (SETQ END (CADR (ASSOC "END" DATA)))
	   (SETQ SIZE (CADR (ASSOC "SIZE" DATA)))
	   (SETQ COLOR (CADR (ASSOC "COLOR" DATA)))
	   (IF (NOT (SETQ RATIO (CADR (ASSOC "RATIO" DATA))))
	     (SETQ RATIO 1.0)
	   )
	   (SETQ START (MAPCAR (QUOTE *)
			       (MAPCAR (QUOTE /) (LIST B H) (LIST 100.0 100.0))
			       START
		       )
	   )
	   (SETQ END (MAPCAR (QUOTE *)
			     (MAPCAR (QUOTE /) (LIST B H) (LIST 100.0 100.0))
			     END
		     )
	   )
	   (SETQ SIZE (* (/ 100.0 (APPLY (QUOTE MIN) (LIST B H))) SIZE))
	   (SETQ P1 (MAPCAR (QUOTE FIX)
			    (POLAR (POLAR END (ANGLE END START) SIZE)
				   (- (ANGLE END START) (/ PI 2.0))
				   (* SIZE RATIO 0.5)
			    )
		    )
	   )
	   (SETQ P2 (MAPCAR (QUOTE FIX)
			    (POLAR (POLAR END (ANGLE END START) SIZE)
				   (+ (ANGLE END START) (/ PI 2.0))
				   (* SIZE RATIO 0.5)
			    )
		    )
	   )
	   (SETQ START (MAPCAR (QUOTE FIX) START))
	   (SETQ END (MAPCAR (QUOTE FIX) END))
	   (SETQ P_LIST	(APPEND	P_LIST
				(LIST (LIST START END COLOR)
				      (LIST END P1 COLOR)
				      (LIST P1 P2 COLOR)
				      (LIST P2 END COLOR)
				)
			)
	   )
	  )
	  ((= ART "LINE")
	   (SETQ START (CADR (ASSOC "START" DATA)))
	   (SETQ END (CADR (ASSOC "END" DATA)))
	   (SETQ COLOR (CADR (ASSOC "COLOR" DATA)))
	   (SETQ START (MAPCAR (QUOTE *)
			       (MAPCAR (QUOTE /) (LIST B H) (LIST 100.0 100.0))
			       START
		       )
	   )
	   (SETQ END (MAPCAR (QUOTE *)
			     (MAPCAR (QUOTE /) (LIST B H) (LIST 100.0 100.0))
			     END
		     )
	   )
	   (SETQ START (MAPCAR (QUOTE FIX) START))
	   (SETQ END (MAPCAR (QUOTE FIX) END))
	   (SETQ P_LIST (APPEND P_LIST (LIST (LIST START END COLOR))))
	  )
	  ((= ART "PLINE")
	   (SETQ PLIST (CDR (ASSOC "PLIST" DATA)))
	   (SETQ COLOR (CADR (ASSOC "COLOR" DATA)))
	   (SETQ PLIST (MAPCAR (QUOTE
				 (LAMBDA (P)
				   (SETQ P (MAPCAR (QUOTE FIX)
						   (MAPCAR (QUOTE *)
							   (MAPCAR (QUOTE /) (LIST B H) (LIST 100.0 100.0))
							   P
						   )
					   )
				   )
				 )
			       )
			       PLIST
		       )
	   )
	   (SETQ P_LIST	(APPEND	P_LIST
				(MAPCAR	(QUOTE (LAMBDA (P1 P2) (LIST P1 P2 COLOR)))
					PLIST
					(APPEND (CDR PLIST) (LIST (CAR PLIST)))
				)
			)
	   )
	  )
	  ((= ART "TEXT")
	   (SETQ TEXT (CADR (ASSOC "TEXT" DATA)))
	   (SETQ COLOR (CADR (ASSOC "COLOR" DATA)))
	   (SETQ HOEHE (CADR (ASSOC "HEIGHT" DATA)))
	   (SETQ BREITE (CADR (ASSOC "WIDTH" DATA)))
	   (IF (NULL BREITE)
	     (SETQ BREITE 1)
	   )
	   (SETQ CHR_LIST (MAPCAR (QUOTE CHR) (VL-STRING->LIST TEXT)))
	   (SETQ POS (CADR (ASSOC "POSITION" DATA)))
	   (SETQ RICHTUNG (CADR (ASSOC "ALIGNMENT" DATA)))
	   (IF (NULL RICHTUNG)
	     (SETQ RICHTUNG "lo")
	   )
	   (SETQ WINKEL (CADR (ASSOC "ANGLE" DATA)))
	   (IF (NULL WINKEL)
	     (SETQ WINKEL 0)
	   )
	   (SETQ POS (MAPCAR (QUOTE *)
			     (MAPCAR (QUOTE /) (LIST B H) (LIST 100.0 100.0))
			     POS
		     )
	   )
	   (SETQ HOEHE (* (/ H 100.0) HOEHE))
	   (SETQ DUMMY_LIST
		  (MAPCAR (QUOTE
			    (LAMBDA (C)
			      (SETQ TEMP_LIST (MAPCAR (QUOTE
							(LAMBDA (PL) (MAPCAR (QUOTE *) PL (LIST 1 HOEHE HOEHE)))
						      )
						      (CADR (ASSOC C FONT_LIST))
					      )
			      )
			      (SETQ C_LIST (VL-REMOVE (QUOTE nil)
						      (MAPCAR (QUOTE
								(LAMBDA	(P1 P2)
								  (COND	((AND (= (CAR P1) 1) (= (CAR P2) 1))
									 (LIST (MAPCAR (QUOTE (LAMBDA (Z) (K_RUNDEN Z 1)))
										       (MAPCAR (QUOTE +)
											       POS
											       (MAPCAR (QUOTE *) (CDR P1) (LIST BREITE 1))
										       )
									       )
									       (MAPCAR (QUOTE (LAMBDA (Z) (K_RUNDEN Z 1)))
										       (MAPCAR (QUOTE +)
											       POS
											       (MAPCAR (QUOTE *) (CDR P2) (LIST BREITE 1))
										       )
									       )
									       COLOR
									 )
									)
									((= (CAR P2) 2)
									 (SETQ POS (MAPCAR (QUOTE +)
											   POS
											   (MAPCAR (QUOTE *) (CDR P2) (LIST BREITE 1))
										   )
									 )
									 nil
									)
								  )
								)
							      )
							      (I-CDR TEMP_LIST)
							      (CDR TEMP_LIST)
						      )
					   )
			      )
			      (SETQ POS	(LIST (MAX (CAR POS)
						   (+ 2
						      (APPLY (QUOTE MAX)
							     (MAPCAR (QUOTE CAR)
								     (VL-REMOVE-IF-NOT
								       (QUOTE LISTP)
								       (APPLY (QUOTE APPEND) C_LIST)
								     )
							     )
						      )
						   )
					      )
					      (CADR POS)
					)
			      )
			      C_LIST
			    )
			  )
			  CHR_LIST
		  )
	   )
	   (SETQ DUMMY_LIST (APPLY (QUOTE APPEND) DUMMY_LIST))
	   (SETQ Y-LIST	(APPEND	(MAPCAR (QUOTE CAAR) DUMMY_LIST)
				(MAPCAR (QUOTE CAADR) DUMMY_LIST)
			)
	   )
	   (SETQ X-LIST	(APPEND	(MAPCAR (QUOTE CADAR) DUMMY_LIST)
				(MAPCAR (QUOTE CADADR) DUMMY_LIST)
			)
	   )
	   (SETQ MIN-Y (APPLY (QUOTE MIN) Y-LIST))
	   (SETQ MAX-Y (APPLY (QUOTE MAX) Y-LIST))
	   (SETQ MIN-X (APPLY (QUOTE MIN) X-LIST))
	   (SETQ MAX-X (APPLY (QUOTE MAX) X-LIST))
	   (SETQ DX (- MAX-X MIN-X))
	   (SETQ DY (- MAX-Y MIN-Y))
	   (COND ((= RICHTUNG "ol") nil)
		 ((= RICHTUNG "ml")
		  (SETQ	DUMMY_LIST
			 (MAPCAR (QUOTE
				   (LAMBDA (DUMMY)
				     (LIST (MAPCAR (QUOTE -) (CAR DUMMY) (LIST 0 (/ DX 2)))
					   (MAPCAR (QUOTE -) (CADR DUMMY) (LIST 0 (/ DX 2)))
					   (CADDR DUMMY)
				     )
				   )
				 )
				 DUMMY_LIST
			 )
		  )
		 )
		 ((= RICHTUNG "ul")
		  (SETQ	DUMMY_LIST
			 (MAPCAR (QUOTE	(LAMBDA	(DUMMY)
					  (LIST	(MAPCAR (QUOTE -) (CAR DUMMY) (LIST 0 DX))
						(MAPCAR (QUOTE -) (CADR DUMMY) (LIST 0 DX))
						(CADDR DUMMY)
					  )
					)
				 )
				 DUMMY_LIST
			 )
		  )
		 )
		 ((= RICHTUNG "oz")
		  (SETQ	DUMMY_LIST
			 (MAPCAR (QUOTE
				   (LAMBDA (DUMMY)
				     (LIST (MAPCAR (QUOTE -) (CAR DUMMY) (LIST (/ DY 2) 0))
					   (MAPCAR (QUOTE -) (CADR DUMMY) (LIST (/ DY 2) 0))
					   (CADDR DUMMY)
				     )
				   )
				 )
				 DUMMY_LIST
			 )
		  )
		 )
		 ((= RICHTUNG "mz")
		  (SETQ	DUMMY_LIST
			 (MAPCAR (QUOTE
				   (LAMBDA (DUMMY)
				     (LIST (MAPCAR (QUOTE -) (CAR DUMMY) (LIST (/ DY 2) (/ DX 2)))
					   (MAPCAR (QUOTE -) (CADR DUMMY) (LIST (/ DY 2) (/ DX 2)))
					   (CADDR DUMMY)
				     )
				   )
				 )
				 DUMMY_LIST
			 )
		  )
		 )
		 ((= RICHTUNG "uz")
		  (SETQ	DUMMY_LIST
			 (MAPCAR (QUOTE
				   (LAMBDA (DUMMY)
				     (LIST (MAPCAR (QUOTE -) (CAR DUMMY) (LIST (/ DY 2) DX))
					   (MAPCAR (QUOTE -) (CADR DUMMY) (LIST (/ DY 2) DX))
					   (CADDR DUMMY)
				     )
				   )
				 )
				 DUMMY_LIST
			 )
		  )
		 )
		 ((= RICHTUNG "or")
		  (SETQ	DUMMY_LIST
			 (MAPCAR (QUOTE	(LAMBDA	(DUMMY)
					  (LIST	(MAPCAR (QUOTE -) (CAR DUMMY) (LIST DY 0))
						(MAPCAR (QUOTE -) (CADR DUMMY) (LIST DY 0))
						(CADDR DUMMY)
					  )
					)
				 )
				 DUMMY_LIST
			 )
		  )
		 )
		 ((= RICHTUNG "mr")
		  (SETQ	DUMMY_LIST
			 (MAPCAR (QUOTE
				   (LAMBDA (DUMMY)
				     (LIST (MAPCAR (QUOTE -) (CAR DUMMY) (LIST DY (/ DX 2)))
					   (MAPCAR (QUOTE -) (CADR DUMMY) (LIST DY (/ DX 2)))
					   (CADDR DUMMY)
				     )
				   )
				 )
				 DUMMY_LIST
			 )
		  )
		 )
		 ((= RICHTUNG "ur")
		  (SETQ	DUMMY_LIST
			 (MAPCAR (QUOTE	(LAMBDA	(DUMMY)
					  (LIST	(MAPCAR (QUOTE -) (CAR DUMMY) (LIST DY DX))
						(MAPCAR (QUOTE -) (CADR DUMMY) (LIST DY DX))
						(CADDR DUMMY)
					  )
					)
				 )
				 DUMMY_LIST
			 )
		  )
		 )
	   )
	   (SETQ POS (MAPCAR (QUOTE *)
			     (MAPCAR (QUOTE /) (LIST B H) (LIST 100.0 100.0))
			     (CADR (ASSOC "POSITION" DATA))
		     )
	   )
	   (SETQ DUMMY_LIST
		  (MAPCAR (QUOTE
			    (LAMBDA (DUMMY)
			      (LIST (:M-ROUNDTOEVEN (K_P_TWIST (CAR DUMMY) POS (- 0 WINKEL)))
				    (:M-ROUNDTOEVEN (K_P_TWIST (CADR DUMMY) POS (- 0 WINKEL)))
				    (LAST DUMMY)
			      )
			    )
			  )
			  DUMMY_LIST
		  )
	   )
	   (SETQ P_LIST (APPEND P_LIST DUMMY_LIST))
	  )
    )
  )
  (START_IMAGE IMAGE_NAME)
  (MAPCAR (QUOTE (LAMBDA (DATA)
		   (VECTOR_IMAGE
		     (NTH 0 (NTH 0 DATA))
		     (NTH 1 (NTH 0 DATA))
		     (NTH 0 (NTH 1 DATA))
		     (NTH 1 (NTH 1 DATA))
		     (NTH 2 DATA)
		   )
		 )
	  )
	  P_LIST
  )
  (END_IMAGE)
)
(DEFUN K_GET_MERKLISTE (NAME / WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ WERT (NTH 1 (ASSOC NAME K_MERKLISTE)))
  )
  WERT
)
(DEFUN K_IS (WERT)
  (COND	((= WERT :vlax-false) nil)
	((= WERT :vlax-true) T)
	((= WERT nil) nil)
	((= WERT T) T)
	((= WERT 1) T)
	((= WERT 0) nil)
	((= WERT "1") T)
	((= WERT "0") nil)
	((= (STRCASE WERT) "JA") T)
	((= (STRCASE WERT) "NEIN") nil)
  )
)
(DEFUN K_ISNOT (WERT) (K_IS (K_NOT WERT)))
(DEFUN K_KOMMA_PUNKT (TXT / DUMMY CP C)
  (COND	((= (TYPE TXT) (QUOTE REAL)) (SETQ TXT (RTOS TXT)))
	((= (TYPE TXT) (QUOTE INT)) (SETQ TXT (ITOA TXT)))
	(T nil)
  )
  (K_TXT-SUBST TXT "," ".")
)
(DEFUN K_LEERTEXT (TXT) (= TXT ""))
(DEFUN K_NOT (WERT)
  (COND	((= WERT :vlax-false) :vlax-true)
	((= WERT :vlax-true) :vlax-false)
	((= WERT nil) T)
	((= WERT T) nil)
	((= WERT 1) 0)
	((= WERT 0) 1)
	((= WERT "1") "0")
	((= WERT "0") "1")
	((= (STRCASE WERT) "JA") "nein")
	((= (STRCASE WERT) "NEIN") "ja")
  )
)
(DEFUN K_ODBX_CONSTRUCT	nil
  (vla-GetInterfaceObject
    (vlax-get-acad-object)
    (STRCAT "ObjectDBX.AxDbDocument."
	    (SUBSTR (GETVAR (QUOTE ACADVER)) 1 2)
    )
  )
)
(DEFUN K_PURGE_LIST (LISTE / DUMMY_LIST)
  (WHILE LISTE
    (SETQ DUMMY_LIST (CONS (CAR LISTE) DUMMY_LIST)
	  LISTE	     (VL-REMOVE (CAR LISTE) LISTE)
    )
  )
  (REVERSE DUMMY_LIST)
)
(DEFUN K_PUT_MERKLISTE (NAME WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ K_MERKLISTE
	   (SUBST (LIST NAME WERT)
		  (ASSOC NAME K_MERKLISTE)
		  K_MERKLISTE
	   )
    )
    (SETQ K_MERKLISTE (CONS (LIST NAME WERT) K_MERKLISTE))
  )
  (PRINC)
)
(DEFUN K_P_TWIST (P PX WX)
  (SETQ	PZ  (CADDR P)
	PXZ (CADDR PX)
  )
  (SETQ	P  (K_3D->2D P)
	PX (K_3D->2D PX)
  )
  (VL-REMOVE (QUOTE nil)
	     (APPEND (POLAR PX (+ (ANGLE PX P) WX) (DISTANCE PX P))
		     (LIST PZ)
	     )
  )
)
(DEFUN K_RESTORE_VAR (VARLIST / K_SAVEVAR_LIST)
  (SETQ K_SAVEVAR_LIST (K_GET_MERKLISTE "k_savevar_list"))
  (IF (= VARLIST "*")
    (SETQ VARLIST (MAPCAR (QUOTE (LAMBDA (VAR) (NTH 0 VAR))) K_SAVEVAR_LIST))
  )
  (IF (= (TYPE VARLIST) (QUOTE STR))
    (SETQ VARLIST (LIST VARLIST))
  )
  (FOREACH VAR VARLIST
    (IF	(SETQ VAR (ASSOC VAR K_SAVEVAR_LIST))
      (SETVAR (NTH 0 VAR) (NTH 1 VAR))
    )
  )
)
(DEFUN K_RUNDEN	(NUM PREC)
  (IF (ZEROP PREC)
    NUM
    (IF	(MEMBER (TYPE NUM) (QUOTE (INT REAL)))
      (* PREC
	 (FIX (IF (MINUSP NUM)
		(- (/ NUM PREC) 0.5)
		(+ (/ NUM PREC) 0.5)
	      )
	 )
      )
      NUM
    )
  )
)
(DEFUN K_SAVE_VAR (VARLIST / K_SAVEVAR_LIST)
  (SETQ K_SAVEVAR_LIST (K_GET_MERKLISTE "k_savevar_list"))
  (IF (= (TYPE VARLIST) (QUOTE STR))
    (SETQ VARLIST (LIST VARLIST))
  )
  (FOREACH VAR VARLIST
    (IF	(ASSOC VAR K_SAVEVAR_LIST)
      (SETQ K_SAVEVAR_LIST
	     (SUBST (LIST VAR (GETVAR VAR))
		    (ASSOC VAR K_SAVEVAR_LIST)
		    K_SAVEVAR_LIST
	     )
      )
      (SETQ K_SAVEVAR_LIST (CONS (LIST VAR (GETVAR VAR)) K_SAVEVAR_LIST))
    )
  )
  (K_PUT_MERKLISTE "k_savevar_list" K_SAVEVAR_LIST)
)
(DEFUN K_TXT-SUBST (TXT ALT_LIST NEU_LIST)
  (IF (NOT (LISTP ALT_LIST))
    (SETQ ALT_LIST (LIST ALT_LIST))
  )
  (IF (NOT (LISTP NEU_LIST))
    (SETQ NEU_LIST (LIST NEU_LIST))
  )
  (WHILE (> (LENGTH ALT_LIST)
	    (MIN (LENGTH ALT_LIST) (LENGTH NEU_LIST))
	 )
    (SETQ ALT_LIST (I-CDR ALT_LIST))
  )
  (WHILE (> (LENGTH NEU_LIST)
	    (MIN (LENGTH ALT_LIST) (LENGTH NEU_LIST))
	 )
    (SETQ NEU_LIST (I-CDR NEU_LIST))
  )
  (MAPCAR (QUOTE
	    (LAMBDA (ALT NEU)
	      (WHILE (NOT (EQUAL TXT (SETQ TXT (VL-STRING-SUBST NEU ALT TXT))))
	      )
	    )
	  )
	  ALT_LIST
	  NEU_LIST
  )
  TXT
)
(DEFUN RAD (Z) (* (/ Z 180.0) PI))
(DEFUN TEMP-FILE (DATA SUFFIX / OPFILE TMPF)
  (SETQ TMPF (VL-FILENAME-MKTEMP (STRCAT "temp~." SUFFIX)))
  (COND	((SETQ OPFILE (OPEN TMPF "w"))
	 (FOREACH LINE DATA (WRITE-LINE LINE OPFILE))
	 (CLOSE OPFILE)
	 TMPF
	)
  )
  TMPF
)
(DEFUN _SETCLIPBOARDTEXT (TEXT / HTMLFILE RESULT)
  (SETQ	RESULT (vlax-invoke
		 (vlax-get (vlax-get (SETQ HTMLFILE (vlax-create-object "htmlfile"))
				     (QUOTE PARENTWINDOW)
			   )
			   (QUOTE CLIPBOARDDATA)
		 )
		 (QUOTE SETDATA)
		 "Text"
		 TEXT
	       )
  )
  (vlax-release-object HTMLFILE)
  TEXT
)

(defun c:k_make-text-lt	(/	     A		 ABSTAND     BESCHR	 D	     DATA	 DBX	     DIALOG_MEM	 FILL_A	     FILL_MITTE	 FILL_OBEN   FILL_R	 FILL_U	     FILL_UNTEN
			 H	     K_make-text-lt_ID	     K_make-text-lt_OK	     L		 MAXP	     MINP	 NAME	     STYLES_LIST TEXTBREITE  TEXTHHE	 TEXTPOSITION
			 TEXTSTIL    TMP	 TXT	     TXT_NAME	 W	     X		 Y
			)
;;; Text-Linientyp erzeugen

  (defun end_k_make-text-lt (wert)
    (k_make-text-lt_daten)
    (setq k_make-text-lt_ok wert)
    (done_dialog)
  )

  (defun k_make-text-lt_daten ()
    (setq txt (get_tile "txt"))
    (setq beschr (get_tile "beschr"))
    (setq name (get_tile "name"))
    (setq textstil (nth (atoi (get_tile "textstil")) styles_list))
    (setq l (atof (k_komma_punkt (get_tile "l"))))
    (setq h (atof (k_komma_punkt (get_tile "h"))))
    (setq d (atof (k_komma_punkt (get_tile "d"))))
    (setq abstand (atof (k_komma_punkt (get_tile "abstand"))))
    (setq a (nth (atoi (get_tile "drehart")) '("A" "R" "U")))
    (setq w (atof (k_komma_punkt (get_tile "drehwinkel"))))
    (k_dialogspeicher nil)
    (k_is (not (equal dialog_mem
		      (setq dialog_mem
			     (cons textposition
				   (k_dialogspeicher
				     '("txt" "beschr" "name" "textstil"	"l" "h"	"d" "drehart" "drehwinkel" "textraum" "gesamtlnge" "abstand")
				   )
			     )
		      )
	       )
	  )
    )
  )

  (defun k_make-text-lt_temp-text ()
    (setq txt_name (vla-addtext
		     (vla-get-modelspace dbx)
		     txt
		     (VLAX-3D-POINT '(0 0))
		     h
		   )
    )
    (vla-put-StyleName
      txt_name
      textstil
    )
    (vla-put-rotation
      txt_name
      (rad w)
    )
    (vla-getboundingbox
      txt_name
      'minp
      'maxp
    )
    (setq minp (vlax-safearray->list minp))
    (setq maxp (vlax-safearray->list maxp))
    (vla-delete txt_name)
    (setq texthhe (cadr (mapcar '- maxp minp)))
    (setq textbreite (car (mapcar '- maxp minp)))
  )

  (defun k_make-text-lt_calc (key)
    (if	(k_make-text-lt_daten)
      (progn
	(k_save_var "luprec")
	(setvar "luprec" 8)

	(cond
	  ((= key "d")
	   (set_tile "textraum" "")
	   (set_tile "gesamtlnge" "")
	  )
	  ((= key "textraum")
	   (set_tile "gesamtlnge" "")
	  )
	  ((= key "gesamtlnge")
	   (set_tile "d" "")
	  )
	)

	(setq minp '(0 0)
	      maxp '(0 0)
	      textbreite
	       0
	)
	(if (and (> (atof (get_tile "h")) 0) (/= (get_tile "txt") ""))
	  (k_make-text-lt_temp-text)
	)
	(cond
	  ((= key "textraum")
	   (set_tile "d"
		     (rtos
		       (max 0.0
			    (/ (- (atof (k_komma_punkt (get_tile "textraum")))
				  textbreite
			       )
			       2.0
			    )
		       )
		     )
	   )
	   (set_tile "textraum"
		     (rtos
		       (+ textbreite (atof (get_tile "d")) (atof (get_tile "d")))
		     )
	   )
	   (cond
	     ((= textposition "mitte")
	      (set_tile	"gesamtlnge"
			(rtos (+ textbreite
				 (atof (get_tile "d"))
				 (atof (get_tile "d"))
				 (atof (get_tile "l"))
			      )
			)
	      )
	     )
	     (t
	      (set_tile	"gesamtlnge"
			(rtos (max (atof (get_tile "l"))
				   (+ textbreite
				      (atof (get_tile "d"))
				      (atof (get_tile "d"))
				   )
			      )
			)
	      )
	     )
	   )
	  )
	  ((= key "gesamtlnge")
	   (cond
	     ((= textposition "mitte")
	      (set_tile	"d"
			(rtos
			  (max 0.0
			       (/ (- (atof (k_komma_punkt (get_tile "gesamtlnge")))
				     textbreite
				     (atof (get_tile "l"))
				  )
				  2.0
			       )
			  )
			)
	      )
	     )
	     (t
	      (set_tile	"l"
			(rtos
			  (max 0.0 (atof (k_komma_punkt (get_tile "gesamtlnge"))))
			)
	      )
	      (set_tile	"d"
			(rtos
			  (max 0.0
			       (/ (- (atof (k_komma_punkt (get_tile "gesamtlnge")))
				     textbreite
				  )
				  2.0
			       )
			  )
			)
	      )
	     )
	   )
	   (set_tile "textraum"
		     (rtos
		       (+ textbreite (atof (get_tile "d")) (atof (get_tile "d")))
		     )
	   )
	   (cond
	     ((= textposition "mitte")
	      (set_tile	"gesamtlnge"
			(rtos (+ textbreite
				 (atof (get_tile "d"))
				 (atof (get_tile "d"))
				 (atof (get_tile "l"))
			      )
			)
	      )
	     )
	     (t
	      (set_tile	"gesamtlnge"
			(rtos (max (atof (get_tile "l"))
				   (+ textbreite
				      (atof (get_tile "d"))
				      (atof (get_tile "d"))
				   )
			      )
			)
	      )
	     )
	   )
	  )
	  (t
	   (set_tile "textraum"
		     (rtos
		       (+ textbreite (atof (get_tile "d")) (atof (get_tile "d")))
		     )
	   )
	   (cond
	     ((= textposition "mitte")
	      (set_tile	"gesamtlnge"
			(rtos (+ textbreite
				 (atof (get_tile "d"))
				 (atof (get_tile "d"))
				 (atof (get_tile "l"))
			      )
			)
	      )
	     )
	     (t
	      (set_tile	"gesamtlnge"
			(rtos (max (atof (get_tile "l"))
				   (+ textbreite
				      (atof (get_tile "d"))
				      (atof (get_tile "d"))
				   )
			      )
			)
	      )
	     )
	   )
	  )
	)
	(k_make-text-lt_daten)
	(cond
	  ((= textposition "oben")
	   (mode_tile "abstand" 0)
	   (set_tile "l"
		     (rtos
		       (setq l (max l
				    (+ textbreite (atof (get_tile "d")) (atof (get_tile "d")))
			       )
		       )
		     )
	   )
	   (k_draw_image
	     "bild"
	     (list
	       '("fill" ("color" 7))
	       '("line"
		 ("start" (5 75))
		 ("end" (95 75))
		 ("color" 0)
		)
	       '("text"
		 ("text" "TEXT")
		 ("position" (50 35))
		 ("height" 40)
		 ("width" 1.75)
		 ("color" 0)
		 ("alignment" "mz")
		 ("ANGLE" 0.0)
		)
	       '("arrow"
		 ("start" (50 70))
		 ("end" (95 70))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (50 70))
		 ("end" (5 70))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       (list "text"
		     (list "text" (rtos l))
		     '("position" (50 63))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     '("ANGLE" 0.0)
	       )
	       '("arrow"
		 ("start" (50 20))
		 ("end" (50 55))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (50 50))
		 ("end" (50 15))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       (list "text"
		     (list "text" (rtos h))
		     '("position" (48.8 35))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     (list "ANGLE" (/ pi 2.0))
	       )
	       '("arrow"
		 ("start" (32 35))
		 ("end" (25 35))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (25 35))
		 ("end" (32 35))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       (list "text"
		     (list "text" (rtos d))
		     '("position" (28.5 29))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     '("ANGLE" 0.0)
	       )
	       '("arrow"
		 ("start" (5 0))
		 ("end" (15 70))
		 ("color" 5)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (27 0))
		 ("end" (28.5 22))
		 ("color" 5)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (52 0))
		 ("end" (50 15))
		 ("color" 5)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	     )
	   )
	  )
	  ((= textposition "mitte")
	   (mode_tile "abstand" 1)
	   (k_draw_image
	     "bild"
	     (list
	       '("fill" ("color" 7))
	       '("line"
		 ("start" (5 50))
		 ("end" (25 50))
		 ("color" 0)
		)
	       '("line"
		 ("start" (75 50))
		 ("end" (95 50))
		 ("color" 0)
		)
	       '("text"
		 ("text" "TEXT")
		 ("position" (50 50))
		 ("height" 40)
		 ("width" 1.75)
		 ("color" 0)
		 ("alignment" "mz")
		 ("ANGLE" 0.0)
		)
	       '("arrow"
		 ("start" (5 47))
		 ("end" (25 47))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (25 47))
		 ("end" (5 47))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       (list "text"
		     (list "text" (rtos l))
		     '("position" (15 38))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     '("ANGLE" 0.0)
	       )
	       '("arrow"
		 ("start" (5 0))
		 ("end" (15 32))
		 ("color" 5)
		 ("size" 10)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (25 47))
		 ("end" (32 47))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (32 47))
		 ("end" (25 47))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       (list "text"
		     (list "text" (rtos d))
		     '("position" (28.5 38))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     '("ANGLE" 0.0)
	       )
	       '("arrow"
		 ("start" (27 0))
		 ("end" (28 32))
		 ("color" 5)
		 ("size" 10)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (50 30))
		 ("end" (50 70))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (50 70))
		 ("end" (50 30))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       (list "text"
		     (list "text" (rtos h))
		     '("position" (48.8 50))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     (list "ANGLE" (/ pi 2.0))
	       )
	       '("arrow"
		 ("start" (52 0))
		 ("end" (50 30))
		 ("color" 5)
		 ("size" 10)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (50 76))
		 ("end" (25 76))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (50 76))
		 ("end" (75 76))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       (list "text"
		     (list "text"
			   (get_tile "textraum")
		     )
		     '("position" (50 82))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     (list "ANGLE" 0)
	       )
	       '("arrow"
		 ("start" (40 100))
		 ("end" (50 88))
		 ("color" 5)
		 ("size" 10)
		 ("ratio" 0.5)
		)
	       '("text"
		 ("text" "TEXT")
		 ("position" (50 50))
		 ("height" 40)
		 ("width" 1.75)
		 ("color" 0)
		 ("alignment" "mz")
		 ("ANGLE" 0.0)
		)
	       '("arrow"
		 ("start" (83 83))
		 ("end" (75 75))
		 ("color" 5)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("text"
		 ("text" "Gesamtlnge geht bis hier")
		 ("position" (75 90))
		 ("height" 7)
		 ("width" 0.90)
		 ("color" 0)
		 ("alignment" "ml")
		 ("ANGLE" 0.0)
		)
	     )
	   )
	  )
	  ((= textposition "unten")
	   (mode_tile "abstand" 0)
	   (set_tile "l"
		     (rtos
		       (setq l (max l
				    (+ textbreite (atof (get_tile "d")) (atof (get_tile "d")))
			       )
		       )
		     )
	   )
	   (k_draw_image
	     "bild"
	     (list
	       '("fill" ("color" 7))
	       '("line"
		 ("start" (5 25))
		 ("end" (95 25))
		 ("color" 0)
		)
	       '("text"
		 ("text" "TEXT")
		 ("position" (50 65))
		 ("height" 40)
		 ("width" 1.75)
		 ("color" 0)
		 ("alignment" "mz")
		 ("ANGLE" 0.0)
		)
	       '("arrow"
		 ("start" (50 30))
		 ("end" (95 30))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (50 30))
		 ("end" (5 30))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       (list "text"
		     (list "text" (rtos l))
		     '("position" (50 36))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     '("ANGLE" 0.0)
	       )
	       '("arrow"
		 ("start" (50 60))
		 ("end" (50 86))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (50 60))
		 ("end" (50 46))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       (list "text"
		     (list "text" (rtos h))
		     '("position" (48.8 66))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     (list "ANGLE" (/ pi 2.0))
	       )
	       (list "text"
		     (list "text" (rtos d))
		     '("position" (28.5 60))
		     '("height" 6)
		     '("width" 1.0)
		     '("color" 1)
		     '("alignment" "mz")
		     '("ANGLE" 0.0)
	       )
	       '("arrow"
		 ("start" (32 68))
		 ("end" (25 68))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (25 68))
		 ("end" (32 68))
		 ("color" 1)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (5 0))
		 ("end" (15 30))
		 ("color" 5)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (27 0))
		 ("end" (28.5 54))
		 ("color" 5)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	       '("arrow"
		 ("start" (52 0))
		 ("end" (50 27))
		 ("color" 5)
		 ("size" 8)
		 ("ratio" 0.5)
		)
	     )
	   )
	  )
	)

	(if (vl-every 'k_isnot
		      (mapcar 'k_leertext
			      (mapcar 'get_tile '("name" "beschr" "l" "d" "h" "txt"))
		      )
	    )
	  (progn
	    (mode_tile "accept" 0)
	    (mode_tile "code" 0)
	  )
	  (progn
	    (mode_tile "accept" 1)
	    (mode_tile "code" 1)
	  )
	)

	(if (and minp
		 maxp
		 (not (k_leertext name))
		 (not (k_leertext beschr))
		 (not (k_leertext txt))
		 l
		 d
		 h
		 a
		 w
	    )
	  (progn
	    (setq x (- (car maxp) (car minp)))
	    (setq y (- (cadr maxp) (cadr minp)))
	    (cond
	      ((= textposition "oben")
	       (setq
		 data (list
			(strcat	"*" name "," beschr " ----" txt	"-----"	txt "----" txt "----")
			(strcat	"A,"
				(rtos (- l 0.00000002))
				",-0.00000001"
				",[\""
				txt
				"\","
				textstil
				",S="
				(rtos h)
				","
				a
				"="
				(rtos w)
				",X="
				(rtos (/ l -2.0))
				",Y="
				(rtos (+ (* (cadr minp) -1) abstand))
				"],"
				"-0.00000001"
			)
		      )
	       )
	      )
	      ((= textposition "mitte")
	       (setq
		 data (list
			(strcat	"*" name "," beschr " ----" txt	"-----"	txt "----" txt "----")
			(strcat	"A,"
				(rtos l)
				","
				(rtos (* (+ x d) -1.0))
				",[\""
				txt
				"\","
				textstil
				",S="
				(rtos h)
				","
				a
				"="
				(rtos w)
				",X="
				(rtos (- 0.0 (+ x (car minp))))
				",Y="
				(rtos (/ y -2.0))
				"],"
				(rtos (- 0.0 d))
			)
		      )
	       )
	      )
	      ((= textposition "unten")
	       (setq
		 data (list
			(strcat	"*" name "," beschr " ----" txt	"-----"	txt "----" txt "----")
			(strcat	"A,"
				(rtos (- l 0.00000002))
				",-0.00000001"
				",[\""
				txt
				"\","
				textstil
				",S="
				(rtos h)
				","
				a
				"="
				(rtos w)
				",X="
				(rtos (/ l -2.0))
				",Y="
				(rtos (- (* (cadr maxp) -1) abstand))
				"],"
				"-0.00000001"
			)
		      )
	       )
	      )
	    )

	    (k_draw_image
	      "code"
	      (list
		'("fill" ("color" 7))
		(list "text"
		      (list "text" (car data))
		      '("position" (1 25))
		      '("height" 20)
		      '("width" 0.8)
		      '("color" 0)
		      '("alignment" "ml")
		      '("ANGLE" 0.0)
		)
		(list "text"
		      (list "text" (cadr data))
		      '("position" (1 75))
		      '("height" 20)
		      '("width" 0.8)
		      '("color" 0)
		      '("alignment" "ml")
		      '("ANGLE" 0.0)
		)
	      )
	    )
	  )
	)
	(k_restore_var "luprec")
      )
    )
  )

  (defun k_make-text-lt_textposition (key)
    (cond
      ((= key "oben")
       (setq fill_oben 7
	     fill_mitte
	      254
	     fill_unten
	      254
	      textposition key
       )
      )
      ((= key "mitte")
       (setq fill_oben 254
	     fill_mitte
	      7
	     fill_unten
	      254
	     textposition key
       )
      )
      ((= key "unten")
       (setq fill_oben 254
	     fill_mitte
	      254
	     fill_unten
	      7
	     textposition key
       )
      )
    )

    (k_draw_image
      "oben"
      (list
	(list "fill" (list "color" fill_oben))
	'("line" ("start" (5 60)) ("end" (95 60)) ("color" 0))
	'("text"
	  ("text" "Text")
	  ("position" (50 40))
	  ("height" 10)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	 )
      )
    )
    (k_draw_image
      "mitte"
      (list
	(list "fill" (list "color" fill_mitte))
	'("line" ("start" (5 50)) ("end" (30 50)) ("color" 0))
	'("line" ("start" (70 50)) ("end" (95 50)) ("color" 0))
	'("text"
	  ("text" "Text")
	  ("position" (50 50))
	  ("height" 10)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	 )
      )
    )
    (k_draw_image
      "unten"
      (list
	(list "fill" (list "color" fill_unten))
	'("line" ("start" (5 40)) ("end" (95 40)) ("color" 0))
	'("text"
	  ("text" "Text")
	  ("position" (50 60))
	  ("height" 10)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	 )
      )
    )
    (k_make-text-lt_calc key)
  )

  (defun k_make-text-lt_drehart	(key)
    (if	(= key "drehart")
      (setq key (nth (atoi (get_tile "drehart")) '("A" "R" "U")))
    )
    (cond
      ((= key "A")
       (setq fill_A 7
	     fill_R 254
	     fill_U 254
       )
       (set_tile "drehart" "0")
      )
      ((= key "R")
       (setq fill_A 254
	     fill_R 7
	     fill_U 254
       )
       (set_tile "drehart" "1")
      )
      ((= key "U")
       (setq fill_A 254
	     fill_R 254
	     fill_U 7
       )
       (set_tile "drehart" "2")
      )
    )
    (k_draw_image
      "A"
      (list
	(list "fill" (list "color" fill_A))
	'("line" ("start" (15 15)) ("end" (35 15)) ("color" 0))
	'("line" ("start" (70 15)) ("end" (85 15)) ("color" 0))
	'("line" ("start" (85 15)) ("end" (85 30)) ("color" 0))
	'("line" ("start" (85 75)) ("end" (85 85)) ("color" 0))
	'("line" ("start" (85 85)) ("end" (70 85)) ("color" 0))
	'("line" ("start" (30 85)) ("end" (15 85)) ("color" 0))
	'("line" ("start" (15 85)) ("end" (15 70)) ("color" 0))
	'("line" ("start" (15 30)) ("end" (15 15)) ("color" 0))
	'("text"
	  ("text" "A")
	  ("position" (50 15))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	 )
	'("text"
	  ("text" "A")
	  ("position" (12 50))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	 )
	'("text"
	  ("text" "A")
	  ("position" (80 50))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	 )
	'("text"
	  ("text" "A")
	  ("position" (50 80))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	 )
      )
    )

    (k_draw_image
      "R"
      (list
	(list "fill" (list "color" fill_R))
	'("line" ("start" (15 15)) ("end" (35 15)) ("color" 0))
	'("line" ("start" (70 15)) ("end" (85 15)) ("color" 0))
	'("line" ("start" (85 15)) ("end" (85 30)) ("color" 0))
	'("line" ("start" (85 75)) ("end" (85 85)) ("color" 0))
	'("line" ("start" (85 85)) ("end" (70 85)) ("color" 0))
	'("line" ("start" (30 85)) ("end" (15 85)) ("color" 0))
	'("line" ("start" (15 85)) ("end" (15 70)) ("color" 0))
	'("line" ("start" (15 30)) ("end" (15 15)) ("color" 0))
	'("text"
	  ("text" "R")
	  ("position" (50 15))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	 )
	'("text"
	  ("text" "R")
	  ("position" (20 50))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	  ("angle" 1.5708)

	 )
	'("text"
	  ("text" "R")
	  ("position" (80 50))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")

	  ("angle" 4.71239)
	 )
	'("text"
	  ("text" "R")
	  ("position" (50 80))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	  ("angle" 3.14159)
	 )
      )
    )

    (k_draw_image
      "U"
      (list
	(list "fill" (list "color" fill_U))
	'("line" ("start" (15 15)) ("end" (35 15)) ("color" 0))
	'("line" ("start" (70 15)) ("end" (85 15)) ("color" 0))
	'("line" ("start" (85 15)) ("end" (85 30)) ("color" 0))
	'("line" ("start" (85 75)) ("end" (85 85)) ("color" 0))
	'("line" ("start" (85 85)) ("end" (70 85)) ("color" 0))
	'("line" ("start" (30 85)) ("end" (15 85)) ("color" 0))
	'("line" ("start" (15 85)) ("end" (15 70)) ("color" 0))
	'("line" ("start" (15 30)) ("end" (15 15)) ("color" 0))
	'("text"
	  ("text" "U")
	  ("position" (50 15))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	 )
	'("text"
	  ("text" "U")
	  ("position" (20 50))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	  ("angle" 1.5708)
	 )
	'("text"
	  ("text" "U")
	  ("position" (80 50))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")
	  ("angle" 1.5708)
	 )
	'("text"
	  ("text" "U")
	  ("position" (50 80))
	  ("height" 24)
	  ("width" 0.8)
	  ("color" 0)
	  ("alignment" "mz")

	 )
      )
    )
    (k_make-text-lt_calc "drehart")
  )

  (defun k_make-text-lt_code ()
    (_SetClipBoardText (strcat (car data) "\r\n" (cadr data)))
  )
;;; ein ODBX-Objekt fr Hilskonstruktionen
  (setq dbx (k_odbx_construct))
;;; Textstile bertragen
  (k_copyobjects
    (k_collection->list (vla-get-textstyles (k_ac-doc)))
    nil
    (vla-get-textstyles dbx)
    t
  )
;;; Textstil Standard anpassen
  (entmod
    (subst (assoc 3
		  (entget
		    (k_->ent_name
		      (vla-item (vla-get-textstyles (k_ac-doc)) "Standard")
		    )
		  )
	   )
	   (assoc 3
		  (entget (k_->ent_name
			    (vla-item (vla-get-textstyles dbx) "Standard")
			  )
		  )
	   )
	   (entget (k_->ent_name
		     (vla-item (vla-get-textstyles dbx) "Standard")
		   )
	   )
    )
  )

  (setq k_make-text-lt_id (load_dialog "k_make-text-lt.dcl"))
  (if (not (new_dialog "k_make_text_lt" k_make-text-lt_id))
    (exit)
  )

  (start_list "textstil")
  (mapcar 'add_list
	  (setq	styles_list
		 (vl-sort (mapcar 'vla-get-name
				  (k_collection->list (vla-get-textstyles (k_ac-doc)))
			  )
			  '<
		 )
	  )
  )
  (end_list)
  (set_tile "textstil"
	    (itoa (vl-position (getvar "textstyle") styles_list))
  )
  (start_list "drehart")
  (mapcar 'add_list '("A" "R" "U"))
  (end_list)
  (set_tile "drehart" "2")
  (set_tile "drehwinkel" "0")
  (mode_tile "accept" 1)
  (mode_tile "code" 1)
  (mode_tile "name" 2)

  (action_tile "oben" "(k_make-text-lt_textposition $key)")
  (action_tile "mitte" "(k_make-text-lt_textposition $key)")
  (action_tile "unten" "(k_make-text-lt_textposition $key)")
  (action_tile "abstand" "(k_make-text-lt_textposition $key)")

  (action_tile "A" "(k_make-text-lt_drehart $key)")
  (action_tile "R" "(k_make-text-lt_drehart $key)")
  (action_tile "U" "(k_make-text-lt_drehart $key)")

  (action_tile "l" "(k_make-text-lt_calc $key)")
  (action_tile "d" "(k_make-text-lt_calc $key)")
  (action_tile "h" "(k_make-text-lt_calc $key)")
  (action_tile "drehart" "(k_make-text-lt_drehart $key)")
  (action_tile "drehwinkel" "(k_make-text-lt_calc $key)")
  (action_tile "txt" "(k_make-text-lt_calc $key)")
  (action_tile "beschr" "(k_make-text-lt_calc $key)")
  (action_tile "name" "(k_make-text-lt_calc $key)")
  (action_tile "textstil" "(k_make-text-lt_calc $key)")
  (action_tile "textraum" "(k_make-text-lt_calc $key)")
  (action_tile "gesamtlnge" "(k_make-text-lt_calc $key)")
  (action_tile "code" "(k_make-text-lt_code)")
  (action_tile "accept" "(end_k_make-text-lt 1)")
  (action_tile "cancel" "(end_k_make-text-lt 0)")
  (k_dialogspeicher nil)
  (k_make-text-lt_textposition "mitte")
  (k_make-text-lt_drehart "U")

  (start_dialog)
  (unload_dialog k_make-text-lt_id)

  (if (= k_make-text-lt_ok 1)
    (progn
      (vl-catch-all-apply
	'vla-Load
	(list (vla-get-Linetypes (k_ac-doc))
	      name
	      (setq tmp (temp-file data "lin"))
	)
      )
      (vl-file-delete tmp)
    )
  )
  (vl-catch-all-apply 'vlax-Release-Object (list dbx))
  (princ)
)
;;; - ------------------------------------------------------------------------------ - ;
(princ
  (strcat
    "\nk_make-text-lt:  Textlinientp erstellen"
    "\n===========  "
    "\n(C) Andreas Kraus 2024 (info@kraus-cad.de)"
    "\nBefehlszeilenaufruf : k_make-text-lt\n"
  )
)
;;; - ------------------------------------------------------------------------------ - ;
(princ)